<?php
session_start();

include('db.php'); // Include database connection

// Check if the user is logged in
$user_id = $_SESSION['user_id'] ?? null;
if (!$user_id) {
    echo json_encode([
        'status' => 'error',
        'message' => 'User not logged in.'
    ]);
    exit;
}

// Get JSON data
$data = json_decode(file_get_contents('php://input'), true);

// Validate input data
if (empty($data['Products']) || !isset($data['Shipping'], $data['Roundoff'], $data['Discount_percentage'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid input data.'
    ]);
    exit;
}

// Assign input data to variables
$customerid = mysqli_real_escape_string($conn, $data['customerid']);
$shipping = !empty($data['Shipping']) ? (float)$data['Shipping'] : 0;
$roundoff = !empty($data['Roundoff']) ? (float)$data['Roundoff'] : 0;
$discount_percentage = (float)$data['Discount_percentage'];
$balance = (float)$data['Balance'];
$paymentid = !empty($data['paymentid']) ? mysqli_real_escape_string($conn, $data['paymentid']) : 0;
$products = $data['Products'];

$grand_total = 0;
$tax_total = 0;
$discount_total = 0;
$product_total = 0;
$total_savings = 0;
$total_discount = 0;

// Fetch customer details
$user_query = "SELECT displayname FROM customer WHERE id = '$customerid' AND delete_status = 0";
$user_result = mysqli_query($conn, $user_query);

if (mysqli_num_rows($user_result) > 0) {
    $user_data = mysqli_fetch_assoc($user_result);
    $displayname = mysqli_real_escape_string($conn, $user_data['displayname']);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Customer not found or inactive.'
    ]);
    exit;
}

// Process each product
foreach ($products as $product) {
    if (!isset($product['Product_id'], $product['Selling_price'], $product['Tax_percentage'], $product['Qty'])) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Invalid product data.'
        ]);
        exit;
    }

    $product_id = mysqli_real_escape_string($conn, $product['Product_id']);
    $selling_price = round((float)$product['Selling_price'], 2);
    $tax_percentage = round((float)$product['Tax_percentage'], 2);
    $qty = (int)$product['Qty'];

    // Fetch product details
    $product_query = "SELECT Product_name, MRP, qty, sale_price_tax FROM product WHERE Product_id = '$product_id' AND Delete_status = 0";
    $product_result = mysqli_query($conn, $product_query);

    if (mysqli_num_rows($product_result) == 0) {
        echo json_encode([
            'status' => 'error',
            'message' => "Product ID $product_id not found or inactive."
        ]);
        exit;
    }

    $product_data = mysqli_fetch_assoc($product_result);
    if ($product_data['qty'] < $qty) {
        echo json_encode([
            'status' => 'error',
            'message' => "Insufficient stock for Product ID $product_id."
        ]);
        exit;
    }

    $mrp = (float)$product_data['MRP'];
    $sale_price_tax = (int)$product_data['sale_price_tax']; // Get sale price tax value (1 or 2)

    // Calculate values
    $discount = ($selling_price * $discount_percentage) / 100;
    $product_subtotal = $selling_price * $qty;
    $tax = 0;

    if ($sale_price_tax == 2) {
        // Only calculate tax if sale_price_tax is 2
        $tax = ($product_subtotal * $tax_percentage) / 100;
    }

    $product_total += $product_subtotal;
    $tax_total += $tax;
    $discount_total += $discount * $qty;
    $total_savings += ($mrp - $selling_price) * $qty;
}

$grand_total = $product_total + $tax_total + $shipping - $roundoff;
$grand_total1 = number_format((float)$grand_total, 2, '.', '');

// Insert into `orders`
$created_date = date('Y-m-d H:i:s');
$due_date = date('Y-m-d', strtotime('+7 days'));

$order_query = "
    INSERT INTO orders (
        Invoice_id, order_no, user_id, displayname, Created_date, Due_date, Balance, 
        Tax, Tax_percentage, Discount, Discount_percentage, Shipping, Roundoff, 
        Total_price, Grand_total, No_of_items, Created_id, Editor_id, Delete_status, 
        Total_saving, Total_discount, Payment_status, Action_status, Payment_id,prebooked
    ) VALUES (
        0, '', '$customerid', '$displayname', '$created_date', '$due_date', '$balance', 
        '$tax_total', '$tax_percentage', '$discount_total', '$discount_percentage', 
        '$shipping', '$roundoff', '$product_total', '$grand_total1', '" . count($products) . "', 
        '$user_id', '$user_id', 0, '$total_savings', '$discount_total', 
        " . ($balance == 0 ? 1 : ($balance < $grand_total ? 2 : 0)) . ", 7, '$paymentid',1
    )";

if (!mysqli_query($conn, $order_query)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to create order.',
        'error' => mysqli_error($conn)
    ]);
    exit;
}

$order_id = mysqli_insert_id($conn); // Get inserted order ID

// Format and update order number
$formatted_order_no = 'ORD-' . str_pad($order_id, 4, '0', STR_PAD_LEFT);
mysqli_query($conn, "UPDATE orders SET order_no = '$formatted_order_no' WHERE order_id = '$order_id'");

// Insert products into `order_data` and update inventory
foreach ($products as $product) {
    $product_id = mysqli_real_escape_string($conn, $product['Product_id']);

    $product_query2 = "SELECT MRP, sale_price_tax FROM product WHERE Product_id = '$product_id' AND Delete_status = 0";
    $product_result2 = mysqli_query($conn, $product_query2);

    $product_data2 = mysqli_fetch_assoc($product_result2);

    $selling_price = (float)$product['Selling_price'];
    $tax_percentage = (float)$product['Tax_percentage'];
    $qty = (int)$product['Qty'];
    $discount_percentage1 = (float)$product['discount_Percentage'];
    $MRP = (float)$product_data2['MRP'];
    $Sale_Price_Tax = $product_data2['sale_price_tax'];
    $discount = ($selling_price * $discount_percentage1) / 100;
    $product_subtotal = $selling_price * $qty;
    $tax = ($product_subtotal * $tax_percentage) / 100;

    $order_data_query = "
        INSERT INTO order_data (
            Order_id, Product_id, qty, Selling_price, MRP, discount, Discount_percentage, 
            Tax_percentage, Tax, salepricetax, Product_total, Delete_status
        ) VALUES (
            '$order_id', '$product_id', '$qty', '$selling_price', '$MRP', '$discount', 
            '$discount_percentage1', '$tax_percentage', '$tax', '$Sale_Price_Tax', '$product_subtotal', 0
        )";

    mysqli_query($conn, $order_data_query);

    // Subtract quantity from the `product` table and update inventory
    $update_product_query = "
        UPDATE product 
        SET qty = qty - '$qty' 
        WHERE Product_id = '$product_id'";
    mysqli_query($conn, $update_product_query);
    
    $update_inventory_query = "UPDATE inventory  
        SET Qty = Qty - '$qty',
        date_modified = NOW()
        WHERE Product_id = '$product_id'";
    mysqli_query($conn, $update_inventory_query);
}

// Return success response
echo json_encode([
    'status' => 'success',
    'message' => 'Order created successfully.',
    'order_id' => $order_id,
    'order_no' => $formatted_order_no,
    'grand_total' => $grand_total
]);
?>